#include <QtGui>

#include "PropertyClassDlg.h"
#include "IntroModeSelectDlg.h"
#include "NameChangeDlg.h"

PropertyClassDlg::PropertyClassDlg(QWidget *parent)
: QDialog(parent,Qt::Window)
{
	
	menuBar = new QMenuBar();
	fileMenu = new QMenu(tr("&File"), this);
    QAction *newAct = fileMenu->addAction(tr("&New..."));
    newAct->setShortcut(tr("Ctrl+N"));
    QAction *quitAct = fileMenu->addAction(tr("E&xit"));
    quitAct->setShortcut(tr("Ctrl+Q"));
    menuBar->addMenu(fileMenu);
	
	//Toolbar  κ
	TableToolbar =  new QToolBar(tr("File"));
	NewTableToolBtn = new QToolButton();
	NewTableToolBtn->setCheckable(true);
    NewTableToolBtn->setChecked(false);
	NewTableToolBtn->setIcon(QIcon("images/filenew_win.png"));
	connect(NewTableToolBtn, SIGNAL(clicked()), this, SLOT(createNewTable()));
	TableToolbar->addWidget(NewTableToolBtn);
	
	//TableWidget  κ
	TableWidget = new QListWidget(this);
    TableWidget->setViewMode(QListView::ListMode);
	TableWidget->setIconSize(QSize(16, 16));
    TableWidget->setMovement(QListView::Static);
    TableWidget->setMaximumWidth(128);
    TableWidget->setSpacing(5);
	
	CurrentPage = new NewTablePage(this);
    NewTablepagesWidget = new QStackedWidget;
    NewTablepagesWidget->addWidget(CurrentPage);	//listwidget Page κ
	
	//ư  κ
	BackBtn			= new QPushButton(tr("ڷ"));
	ApplyBtn		= new QPushButton(tr(""));
	CancelBtn		= new QPushButton(tr(""));
	
	createLists();
    TableWidget->setCurrentRow(0);
	
	connect(newAct, SIGNAL(triggered()), this, SLOT(createNewTable()));
    connect(quitAct, SIGNAL(triggered()), this, SLOT(closeDialog()));
	
	connect(BackBtn, SIGNAL(clicked()), this, SLOT(ClickBack()));
	connect(ApplyBtn, SIGNAL(clicked()), this, SLOT(ClickApply()));
	connect(CancelBtn, SIGNAL(clicked()), this, SLOT(ClickCancel()));
	
    QHBoxLayout *TableLayout = new QHBoxLayout;
    TableLayout->addWidget(TableWidget);
    TableLayout->addWidget(NewTablepagesWidget, 1);
	
	QHBoxLayout * BtnLayout = new QHBoxLayout;
	BtnLayout->addWidget(BackBtn);
	BtnLayout->addWidget(ApplyBtn);
	BtnLayout->addWidget(CancelBtn);
	BtnLayout->setAlignment(Qt::AlignBottom | Qt::AlignRight);
	
    QVBoxLayout *PropertyTableBoxLayout = new QVBoxLayout;
	PropertyTableBoxLayout->addWidget(menuBar);
	PropertyTableBoxLayout->addWidget(TableToolbar);
	PropertyTableBoxLayout->addLayout(TableLayout);
	PropertyTableBoxLayout->addLayout(BtnLayout);
	setLayout(PropertyTableBoxLayout);
	
	setGeometry(100,100,900,500);
	
    setWindowTitle(tr("̺ Ӽ "));
}

PropertyClassDlg::~PropertyClassDlg()
{
}

void PropertyClassDlg::createLists()
{
	FirstItemText = tr("NewTable");
	
    SampleTableButton = new QListWidgetItem(TableWidget);
    SampleTableButton->setIcon(QIcon("images/Table.png"));
    SampleTableButton->setText(FirstItemText);
    SampleTableButton->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
	
    connect(TableWidget,SIGNAL(currentItemChanged(QListWidgetItem *, QListWidgetItem *)),
		this, SLOT(changePage(QListWidgetItem *, QListWidgetItem*)));
	connect(TableWidget,SIGNAL(itemDoubleClicked(QListWidgetItem *)),this,SLOT(ItemDClick()));
}

void PropertyClassDlg::createNewTable()
{
	QString NewTableName;
	int TableWidgetCount = TableWidget->count();
	
	NameChangeDlg	*NameChange = new NameChangeDlg();
	if (NameChange->exec() == QDialog::Accepted)
	{
		NewTableName =  NewName(NameChange->sendTableName());
		
		for(int nameCount =0;nameCount<TableWidgetCount;nameCount++)
		{
			if(TableWidget->item(nameCount)->text() == NewTableName)
			{
				QMessageBox::StandardButton Message;
				Message = QMessageBox::warning(this, tr("̸Է "),
					tr("̹ ϴ ̺ ̸Դϴ.\n"
					"ٸ ̸ ԷϽʽÿ."),QMessageBox::Yes);
				break;
			}
		}
		
		CurrentPage = new NewTablePage(this);
		NewTablepagesWidget->addWidget(CurrentPage);	//listwidget Page κ
		
		NewTableButton = new QListWidgetItem(TableWidget);
		NewTableButton->setIcon(QIcon("images/Table.png"));
		NewTableButton->setText(NewTableName);
		NewTableButton->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
		
	}
	NewTableToolBtn->setChecked(false);
}

void PropertyClassDlg::closeDialog()
{	
	QMessageBox::StandardButton closeMessage;
	closeMessage = QMessageBox::warning(this, tr(""),
		tr("̺ ⸦ մϴ.\n"
		" Ͻðڽϱ?"),
		QMessageBox::Yes | QMessageBox::No);
	
	if (closeMessage == QMessageBox::Yes)
		reject();
}

void PropertyClassDlg::changePage(QListWidgetItem *current, QListWidgetItem *previous)
{
	if(previous==0){
		qDebug() << "changePageBreak";
		return;
	}
	
	if (!current)
        current = previous;
	
	QString TableText = previous->text();
	
	int itemCnt = TableWidget->count();
	int Item;
	for(Item=0;Item<itemCnt;Item++)
	{
		if(TableText == TableWidget->item(Item)->text())
		{ 
			break;
		}
	}
	
	int state = 0;
	for( int i=0; i<tableInfo.count(); i++){
		if( tableInfo[i]->getTableName() == TableText ){
			state = 1;
			break;
		}
	}
	
	if( state == 0 ){
		tableProperty* tableItem = new tableProperty();
		tableInfo << tableItem;
		
	}
	
	tableInfo[Item]->setTableName(TableText);		//table ̸ Է
	tableInfo[Item]->setIndex(Item);
	
	NewTablePage		*previousWidget;
	previousWidget =(NewTablePage*)(NewTablepagesWidget->widget( Item )); 
	
	bool fPrimaryKey;			
	QString	fFieldName;			
	QString	fFieldDataType;		
	QString fLength;
	int fNotNull;			
	QString fDefaultVaule;		
	QString fComment;
	
	
	
	int tableCnt = previousWidget->TableProperty->rowCount(); 
	
	if( tableInfo[Item]->fieldInfo.count() > 0 ){
		tableInfo[Item]->fieldInfo.clear();
	}
	
	for(int cnt=0;cnt<tableCnt;cnt++)
	{
		if(!previousWidget->TableProperty->item(cnt,0))
			fPrimaryKey = 0;
		else
			fPrimaryKey = 1;
		
		qDebug()<<fPrimaryKey ;			
		fFieldName =  previousWidget->TableProperty->item(cnt,1)->text();
		qDebug()<<fFieldName ; 
		
		if(fFieldName == tr("")){
			continue;
		}
		
		qDebug() << ((QComboBox*)(previousWidget->TableProperty->cellWidget(cnt,2)));
		
		fFieldDataType = ((QComboBox*)(previousWidget->TableProperty->cellWidget(cnt,2)))->currentText();
		qDebug()<<fFieldDataType ; 
		fLength = previousWidget->TableProperty->item(cnt,3)->text();
		qDebug()<<fLength ; 
		fNotNull = ((QCheckBox*)(previousWidget->TableProperty->cellWidget(cnt,4)))->checkState();
		qDebug()<<fNotNull ; 
		fDefaultVaule = previousWidget->TableProperty->item(cnt,5)->text();	
		qDebug()<<fDefaultVaule ; 
		fComment = previousWidget->TableProperty->item(cnt,6)->text();
		qDebug()<<fComment ;
		
		
		tableInfo[Item]->setfieldInfo(cnt,fPrimaryKey,fFieldName,fFieldDataType,fLength,fNotNull,fDefaultVaule,fComment);
	}
	
	
	NewTablepagesWidget->setCurrentIndex(TableWidget->row(current));	
	CurrentPage = (NewTablePage*)NewTablepagesWidget->currentWidget();
}

void PropertyClassDlg::ItemDClick()
{
	NameChangeDlg	*NameChange = new NameChangeDlg();
	if (NameChange->exec() == QDialog::Accepted)
		changeName(NameChange->sendTableName());
}

QString PropertyClassDlg::NewName(const QString &name)
{
	return name;	
}

void PropertyClassDlg::changeName(const QString &name)
{
	NewTablePage	*CurrentPage = new NewTablePage(this);
	NewTablePage	*OtherPage = new NewTablePage(this);
	int CurrentIndex = TableWidget->currentRow();
	int AllIndexCount = TableWidget->count();
	QString	strCurrent = TableWidget->currentItem()->text();
	qDebug() << name;
	
	int itemCnt = tableInfo.count();	
	for(int Item=0;Item<itemCnt;Item++)
	{
		if(tableInfo[Item]->getTableName() == strCurrent)
		{
			tableInfo[Item]->setTableName(name);
		}
	}	
	TableWidget->currentItem()->setText(name);
	qDebug() << name;
	
}

void PropertyClassDlg::RelationTableNames(const QString &name)
{
	int allPages = TableWidget->count();
	for(int cnt=0;cnt<allPages;cnt++)
	{
		
	}
	
}

void PropertyClassDlg::execSql()
{
	int tableCount = tableInfo.count();

	for(int cnt=0; cnt<tableCount;cnt++)
	{
		QString tableName = tableInfo[cnt]->getTableName();
		tableQueryMaker.TableName(tableName);
		QString fieldQuery = tr("");
		createTableQuery = QSqlQuery(tableQueryMaker.clearTable());	
		qDebug() << tableQueryMaker.clearTable();
		createTableQuery.exec();
		QString temp = tableQueryMaker.createTable();
		qDebug() << "tableName"<<tableName;
		qDebug() << temp;
		createTableQuery = QSqlQuery(temp);
		createTableQuery.exec();
		
		int fieldCount = (tableInfo[cnt]->fieldInfo).count();
		qDebug() <<"fieldCount : "<< fieldCount;
		
		for(int fCnt=0;fCnt<fieldCount;fCnt++)
		{
			bool primaryKey = tableInfo[cnt]->fieldInfo[fCnt]->getPrimaryKey();
			qDebug() << primaryKey;
			
			QString fieldName = tableInfo[cnt]->fieldInfo[fCnt]->getFieldName();
			if(fieldName == tr(" "))
			{
				QMessageBox::StandardButton closeMessage;
				closeMessage = QMessageBox::warning(this, tr("ۼ"),
					tr("ʵ带 ۼ  ̺ մϴ.\n"
					"ʵ带 ۼϿ ֽʽÿ."), QMessageBox::No | QMessageBox::Yes);
				break;
			}
			qDebug() << fieldName;
			QString fieldDataType = tableInfo[cnt]->fieldInfo[fCnt]->getFieldDataType();
			qDebug() << fieldDataType;
			QString fieldLength = tableInfo[cnt]->fieldInfo[fCnt]->getFieldLength();
			qDebug() << fieldLength;
			bool null = tableInfo[cnt]->fieldInfo[fCnt]->getNotNull();
			qDebug() << null;
			QString defaultValue = tableInfo[cnt]->fieldInfo[fCnt]->getDefaultVaule();
			qDebug() << defaultValue;
			QString comment = tableInfo[cnt]->fieldInfo[fCnt]->getComment();
			qDebug() << comment;
			fieldQuery  += tableQueryMaker.createField(fieldCount, fCnt, fieldName, fieldDataType, fieldLength, null);
			
			qDebug()<<fieldQuery;
			createTableQuery = QSqlQuery(fieldQuery);
			createTableQuery.exec();
			fieldQuery.clear();
			
			tableQueryMaker.PrimaryFields(primaryKey,fieldName);
		}
		if(tableQueryMaker.primaryFieldCount() > 0)
		{
			qDebug()<<tableQueryMaker.createPrimaryField();
			createTableQuery = QSqlQuery(tableQueryMaker.createPrimaryField());	
			createTableQuery.exec();
		}
		qDebug()<<tableQueryMaker.endMakeTable();
	}
}

void PropertyClassDlg::ClickBack()
{
	accept ();
	
	IntroModeSelectDlg	*SelectMode = new IntroModeSelectDlg();
	SelectMode->exec();
}

void PropertyClassDlg::ClickApply()
{
	int Item = TableWidget->currentRow();	
	QString TableText = TableWidget-> currentItem()->text();
	
	
	if( Item >= tableInfo.count() ){
		tableProperty* tableItem = new tableProperty();
		tableInfo << tableItem;
	}
	
	
	tableInfo[Item]->setTableName(TableText);		//table ̸ Է
	
	qDebug()<<"TableText:"<<TableText ;
	tableInfo[Item]->setIndex(Item);
	
	bool fPrimaryKey;			
	QString	fFieldName;		
	QString	fFieldDataType;		
	QString fLength;
	int fNotNull;			
	QString fDefaultVaule;		
	QString fComment;
	
	int tableCnt = this->CurrentPage->TableProperty->rowCount(); 
	
	if( tableInfo[Item]->fieldInfo.count() > 0 ){
		tableInfo[Item]->fieldInfo.clear();
	}
	
	for(int cnt=0;cnt<tableCnt;cnt++)
	{
		if(!this->CurrentPage->TableProperty->item(cnt,0))
			fPrimaryKey = 0;
		else
			fPrimaryKey = 1;
		
		qDebug()<<fPrimaryKey ;			
		fFieldName =  this->CurrentPage->TableProperty->item(cnt,1)->text();	
		qDebug()<<fFieldName ; 
		
		if(fFieldName == tr(""))
			continue;
		
		fFieldDataType = ((QComboBox*)(this->CurrentPage->TableProperty->cellWidget(cnt,2)))->currentText();
		qDebug()<<fFieldDataType ; 
		fLength = this->CurrentPage->TableProperty->item(cnt,3)->text();
		qDebug()<<fLength ; 
		fNotNull = ((QCheckBox*)(this->CurrentPage->TableProperty->cellWidget(cnt,4)))->checkState();
		qDebug()<<fNotNull ; 
		fDefaultVaule = this->CurrentPage->TableProperty->item(cnt,5)->text();	
		qDebug()<<fDefaultVaule ; 
		fComment = this->CurrentPage->TableProperty->item(cnt,6)->text();
		qDebug()<<fComment ;
		
		tableInfo[Item]->setfieldInfo(cnt,fPrimaryKey,fFieldName,fFieldDataType,fLength,fNotNull,fDefaultVaule,fComment);
	}
	
	QMessageBox::StandardButton closeMessage;
	closeMessage = QMessageBox::warning(this, tr("ϱ"),
		tr("ۼϽ  մϴ.\n"
		" Ͻðڽϱ?"), QMessageBox::No | QMessageBox::Yes);
	
	if (closeMessage == QMessageBox::Yes)
	{
		if(tableInfo[Item]->fieldInfo.count() == 0)
		{
			QMessageBox::StandardButton closeMessage;
			closeMessage = QMessageBox::warning(this, tr("ۼ"),
				tr("ʵ尡 ϳ ϴ.\n"
				"ʵ带 Ͽ ֽʽÿ."), QMessageBox::No | QMessageBox::Yes);
		}
		else
		{
			execSql();
			accept ();
		}
	}
	this->close();
}

void PropertyClassDlg::ClickCancel()
{
	QMessageBox::StandardButton closeMessage;
	closeMessage = QMessageBox::warning(this, tr(""),
		tr("̺ ⸦ մϴ.\n"
		" Ͻðڽϱ?"),
		QMessageBox::No | QMessageBox::Yes);
	
	if (closeMessage == QMessageBox::Yes)
		reject();
}
